import React from "react";
import { Link, useNavigate } from "react-router-dom";

export default function Navbar() {
  const navigate = useNavigate();
  const token = localStorage.getItem("authToken");

  function handleLogout() {
    localStorage.removeItem("authToken");
    navigate("/login");
  }

  return (
    <nav className="bg-indigo-600 text-white p-4 flex justify-between items-center z-50">
      <Link to="/" className="text-xl font-bold">
        FileShare
      </Link>
      <div className="space-x-4">
        {token ? (
          <div className="flex justify-between items-center gap-2">
            <button
              onClick={handleLogout}
              className="bg-white text-indigo-600 px-3 py-1 rounded-lg hover:bg-gray-100"
            >
              Logout
            </button>
          </div>
        ) : (
          <>
            <Link to="/login">Login</Link>
            <Link to="/register">Register</Link>
          </>
        )}
      </div>
    </nav>
  );
}
